/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import jclass.bwt.JCSerializable;
import jclass.chart.ChartCanvas;
import jclass.chart.ChartText;
import jclass.chart.JCAxis;
import jclass.chart.JCChartArea;
import jclass.chart.JCChartUtil;
import jclass.chart.JCLabelGenerator;
import jclass.util.JCString;

public class JCValueLabel
implements JCSerializable {
    double value;
    ChartText label = new ChartText();

    public ChartText getChartText() {
        return this.label;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        if (this.value == d) {
            return;
        }
        this.value = d;
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String string) {
        this.label.setText(string, true);
    }

    public JCValueLabel() {
        this.value = 0.0;
    }

    public JCValueLabel(double d, String string, boolean bl) {
        this.value = d;
        this.label = new ChartText(null, string, bl);
    }

    public JCValueLabel(double d, String string) {
        this.value = d;
        this.label.updateParent = false;
        this.label.setText(string, true);
        this.label.updateParent = true;
    }

    void setParent(JCAxis jCAxis) {
        if (this.label.parent == null) {
            this.label.setParent(jCAxis.chartArea);
        }
        this.label.updateParent = false;
        this.label.setFont(jCAxis.getFont());
        this.label.updateParent = true;
    }

    JCValueLabel(JCAxis jCAxis, double d, int n) {
        JCChartArea jCChartArea;
        this.value = d;
        JCChartArea jCChartArea2 = jCChartArea = jCAxis == null ? null : jCAxis.chartArea;
        if (jCAxis != null && jCAxis.labelGenerator != null) {
            this.setGeneratedLabel(jCChartArea, d, n, jCAxis.labelGenerator);
        } else {
            String string = JCChartUtil.format(d, n);
            this.label = new ChartText(jCChartArea, string, false);
            this.label.updateParent = false;
            if (jCAxis != null) {
                this.label.setRotation(jCAxis.annotationRotation);
            }
            this.label.updateParent = true;
        }
        this.setParent(jCAxis);
    }

    JCValueLabel(JCAxis jCAxis, int n, int n2) {
        JCChartArea jCChartArea;
        this.value = JCChartUtil.pow10(n);
        JCChartArea jCChartArea2 = jCChartArea = jCAxis == null ? null : jCAxis.chartArea;
        if (jCAxis != null && jCAxis.labelGenerator != null) {
            this.setGeneratedLabel(jCChartArea, n, n2, jCAxis.labelGenerator);
        } else {
            String string = JCChartUtil.logFormat(n);
            this.label = new ChartText(jCChartArea, string, false);
            this.label.updateParent = false;
            if (jCAxis != null) {
                this.label.setRotation(jCAxis.annotationRotation);
            }
            this.label.updateParent = true;
        }
        this.setParent(jCAxis);
    }

    private void setGeneratedLabel(ChartCanvas chartCanvas, double d, int n, JCLabelGenerator jCLabelGenerator) {
        if (jCLabelGenerator == null) {
            return;
        }
        Object object = jCLabelGenerator.makeLabel(d, n);
        if (object instanceof JCString) {
            this.label = new ChartText(chartCanvas, (JCString)object);
            return;
        }
        if (object instanceof ChartText) {
            this.label = (ChartText)object;
            this.label.setParent(chartCanvas);
            return;
        }
        String string = object instanceof String ? (String)object : object.toString();
        this.label = new ChartText(chartCanvas, string, true);
    }

    public String toString() {
        if (this.label.realContents == null) {
            return "";
        }
        return this.label.realContents.getString();
    }
}

